---
title: Set up DNS filtering · Cloudflare One docs
description: Secure Web Gateway allows you to inspect DNS traffic and control
  which websites users can visit.
lastUpdated: 2025-11-20T23:13:05.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/dns/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/dns/index.md
---

Secure Web Gateway allows you to inspect DNS traffic and control which websites users can visit.

Note

For a more detailed guide to filtering DNS queries and other traffic for your organization, refer to the [Secure your Internet traffic and SaaS apps](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/concepts/) implementation guide.

## 1. Connect to Gateway

### Connect devices

To filter DNS requests from an individual device such as a laptop or phone:

1. [Install the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on your device.
2. In the WARP client Settings, log in to your organization's Zero Trust instance.
3. (Optional) If you want to display a [custom block page](https://developers.cloudflare.com/cloudflare-one/reusable-components/custom-pages/gateway-block-page/), [install a Cloudflare root certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) on your device.

### Connect DNS locations

To filter DNS requests from a location such as an office or data center:

1. [Add the location](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/) to your Cloudflare One settings.
2. On your router, browser, or OS, forward DNS queries to the address shown in the location setup UI.

Note

Gateway identifies locations differently depending on the DNS query protocol:

* **IPv4 queries** match to the source IP address. Under **Networks** > **Resolvers & Proxies** > **DNS locations**, ensure that the **Source IPv4 Address** parameter is correct for the location you want to apply policies to.
* **IPv6, DOT, or DOH queries** match to the unique DNS forwarding address assigned to the DNS location. Ensure that your DNS resolver is configured for the location you want to apply policies to.

## 2. Verify device connectivity

To verify your device is connected to Cloudflare One:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Traffic settings**.
2. Under **Log traffic activity**, enable activity logging for all DNS logs.
3. On your device, open a browser and go to any website.
4. In Cloudflare One, go to **Insights** > **Logs** > **DNS**.
5. Make sure DNS queries from your device appear.

## 3. Create your first DNS policy

To create a new DNS policy:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Traffic policies** > **Firewall policies**.

  2. In the **DNS** tab, select **Add a policy**.

  3. Name the policy.

  4. Under **Traffic**, build a logical expression that defines the traffic you want to allow or block.

  5. Choose an **Action** to take when traffic matches the logical expression. For example, we recommend adding a policy to block all [security categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#security-categories):

     | Selector | Operator | Value | Action |
     | - | - | - | - |
     | Security Categories | in | *All security risks* | Block |

  6. Select **Create policy**.

* API

  1. [Create an API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with the following permissions:

     | Type | Item | Permission |
     | - | - | - |
     | Account | Zero Trust | Edit |

  2. (Optional) Configure your API environment variables to include your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and API token.

  3. Send a `POST` request to the [Create a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) endpoint. For example, we recommend adding a policy to block all [security categories](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#security-categories):

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Block security threats",
         "description": "Block all default Cloudflare DNS security categories",
         "precedence": 0,
         "enabled": true,
         "action": "block",
         "filters": [
             "dns"
         ],
         "traffic": "any(dns.security_category[*] in {68 178 80 83 176 175 117 131 134 151 153})",
         "identity": ""
       }'
     ```

     ```sh
     {
        "success": true,
        "errors": [],
        "messages": []
     }
     ```

     The API will respond with a summary of the policy and the result of your request.

For more information, refer to [DNS policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/).

## 4. Add optional policies

Refer to our list of [common DNS policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/common-policies) for other policies you may want to create.
