---
title: Overview · Cloudflare R2 docs
description: Cloudflare R2 is a cost-effective, scalable object storage solution
  for cloud-native apps, web content, and data lakes without egress fees.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/r2/
  md: https://developers.cloudflare.com/r2/index.md
---

Object storage for all your data.

Cloudflare R2 Storage allows developers to store large amounts of unstructured data without the costly egress bandwidth fees associated with typical cloud storage services.

You can use R2 for multiple scenarios, including but not limited to:

* Storage for cloud-native applications
* Cloud storage for web content
* Storage for podcast episodes
* Data lakes (analytics and big data)
* Cloud storage output for large batch processes, such as machine learning model artifacts or datasets

[Get started](https://developers.cloudflare.com/r2/get-started/)

[Browse the examples](https://developers.cloudflare.com/r2/examples/)

***

## Features

### Location Hints

Location Hints are optional parameters you can provide during bucket creation to indicate the primary geographical location you expect data will be accessed from.

[Use Location Hints](https://developers.cloudflare.com/r2/reference/data-location/#location-hints)

### CORS

Configure CORS to interact with objects in your bucket and configure policies on your bucket.

[Use CORS](https://developers.cloudflare.com/r2/buckets/cors/)

### Public buckets

Public buckets expose the contents of your R2 bucket directly to the Internet.

[Use Public buckets](https://developers.cloudflare.com/r2/buckets/public-buckets/)

### Bucket scoped tokens

Create bucket scoped tokens for granular control over who can access your data.

[Use Bucket scoped tokens](https://developers.cloudflare.com/r2/api/tokens/)

***

## Related products

**[Workers](https://developers.cloudflare.com/workers/)**

A [serverless](https://www.cloudflare.com/learning/serverless/what-is-serverless/) execution environment that allows you to create entirely new applications or augment existing ones without configuring or maintaining infrastructure.

**[Stream](https://developers.cloudflare.com/stream/)**

Upload, store, encode, and deliver live and on-demand video with one API, without configuring or maintaining infrastructure.

**[Images](https://developers.cloudflare.com/images/)**

A suite of products tailored to your image-processing needs.

***

## More resources

[Pricing](https://developers.cloudflare.com/r2/pricing)

Understand pricing for free and paid tier rates.

[Discord](https://discord.cloudflare.com)

Ask questions, show off what you are building, and discuss the platform with other developers.

[Twitter](https://x.com/cloudflaredev)

Learn about product announcements, new tutorials, and what is new in Cloudflare Workers.
