---
title: WAF attack score · Cloudflare Web Application Firewall (WAF) docs
description: The attack score traffic detection helps identify variations of
  known attacks and their malicious payloads. This detection complements WAF
  Managed Rules.
lastUpdated: 2025-08-22T11:24:36.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/attack-score/
  md: https://developers.cloudflare.com/waf/detections/attack-score/index.md
---

The attack score [traffic detection](https://developers.cloudflare.com/waf/concepts/#detection-versus-mitigation) helps identify variations of known attacks and their malicious payloads. This detection complements [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/).

WAF's managed rulesets contain rules that are continuously updated to better detect malicious payloads. They target specific patterns of established attack vectors and have a very low rate of false positives. However, managed rulesets are not optimized for attacks based on variations of the original signature introduced, for example, by fuzzing techniques.

Attack score allows you to identify these attack variations and their malicious payloads. It classifies each request using a machine learning algorithm, assigning an attack score from 1 to 99 based on the likelihood that the request is malicious. Just like [Bot Management](https://developers.cloudflare.com/bots/plans/bm-subscription/), you can use this score to identify potentially malicious traffic that is not an exact match to any of the rules in WAF Managed Rules.

To maximize protection, Cloudflare recommends that you use both Managed Rules and attack score.

Note

This feature is available to Enterprise customers. Business plans have access to a single field (WAF Attack Score Class).

## Available scores

The Cloudflare WAF provides the following attack score fields:

| Field | Description | Required plan |
| - | - | - |
| WAF Attack Score [`cf.waf.score`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.score/) Number | A global score from 1–99 that combines the score of each WAF attack vector into a single score. | Enterprise |
| WAF SQLi Attack Score [`cf.waf.score.sqli`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.score.sqli/) Number | A score from 1–99 classifying the [SQL injection](https://www.cloudflare.com/learning/security/threats/sql-injection/) (SQLi) attack vector. | Enterprise |
| WAF XSS Attack Score [`cf.waf.score.xss`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.score.xss/) Number | A score from 1–99 classifying the [cross-site scripting](https://www.cloudflare.com/learning/security/threats/cross-site-scripting/) (XSS) attack vector. | Enterprise |
| WAF RCE Attack Score [`cf.waf.score.rce`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.score.rce/) Number | A score from 1–99 classifying the command injection or [remote code execution](https://www.cloudflare.com/learning/security/what-is-remote-code-execution/) (RCE) attack vector. | Enterprise |
| WAF Attack Score Class [`cf.waf.score.class`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.score.class/) String | The attack score class of the current request, based on the WAF attack score. Possible values: `attack`, `likely_attack`, `likely_clean`, and `clean`. | Business or above |

You can use these fields in expressions of [custom rules](https://developers.cloudflare.com/waf/custom-rules/) and [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/). Attack score fields of data type `Number` vary between `1` and `99` with the following meaning:

* A score of `1` indicates that the request is almost certainly malicious.
* A score of `99` indicates that the request is likely clean.

The special score `100` indicates that the Cloudflare WAF did not score the request.

The global WAF Attack Score is mathematically derived from individual attack scores (for example, from SQLi Attack Score and XSS Attack Score), reflecting their interdependence. However, the global score is not a sum of individual scores. A low global score usually indicates medium to low individual scores, while a high global score suggests higher individual scores.

The WAF Attack Score Class field can have one of the following values, depending on the calculated request attack score:

| Dashboard label | Field value | Description |
| - | - | - |
| *Attack* | `attack` | Attack score between `1` and `20`. |
| *Likely attack* | `likely_attack` | Attack score between `21` and `50`. |
| *Likely clean* | `likely_clean` | Attack score between `51` and `80`. |
| *Clean* | `clean` | Attack score between `81` and `99`. |

Requests with the special attack score `100` will show a WAF Attack Score Class of *Unscored* in the Cloudflare dashboard, but you cannot use this class value in rule expressions.

Attack score automatically detects and decodes Base64, JavaScript (Unicode escape sequences), and URL encoded content anywhere in the request: URL, headers, and body.

## Rule recommendations

Cloudflare does not recommend that you block traffic solely based on the WAF Attack Score for all values below `50`, since the *Likely attack* range (scores between `21` and `50`) tends to have false positives. If you want to block traffic based on this score, do one of the following:

* Use a more strict WAF Attack Score value in your expression. For example, block traffic with a WAF attack score below `20` or below `15` (you may need to adjust the exact threshold).

* Combine a higher WAF Attack Score threshold with additional filters when blocking incoming traffic. For example, include a check for a specific URI path in your expression or use bot score as part of your criteria.

***

## Start using WAF attack score

### 1. Create a custom rule

If you are an Enterprise customer, [create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) that blocks requests with a **WAF Attack Score** less than or equal to 20 (recommended initial threshold). For example:

| Field | Operator | Value |
| - | - | - |
| WAF Attack Score | less than or equal to | `20` |

* Equivalent rule expression: `cf.waf.score le 20`
* Action: *Block*

Business customers must create a custom rule with the **WAF Attack Score Class** field instead. For example, use this field to block incoming requests with a score class of *Attack*:

| Field | Operator | Value |
| - | - | - |
| WAF Attack Score Class | equals | `Attack` |

* Equivalent rule expression: `cf.waf.score.class eq "attack"`
* Action: *Block*

### 2. Monitor domain traffic

Monitor the rule you created, especially in the first few days, to make sure you entered an appropriate threshold (or class) for your traffic. Update the rule if required.

### 3. Update the rule action

If you are an Enterprise customer and you created a rule with *Log* action, change the rule action to a more severe one, like *Managed Challenge* or *Block*.

***

## Additional remarks

The WAF attack score is different from [bot score](https://developers.cloudflare.com/bots/concepts/bot-score/). WAF attack score identifies variations of attacks that WAF Managed Rules do not catch, while bot score identifies bots.
